﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<GetConsultsStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetConsultsStateObject state)
        {
            try
            {
                state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.RequestMessage.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Get Consults ConnectToCrmStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}